/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.client.gui.button;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.client.gui.GuiSkills;
import codersafterdark.reskillable.client.gui.handler.InventoryTabHandler;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiButtonInventoryTab
extends GuiButton {
    public final TabType type;
    private final Predicate<GuiScreen> selectedPred;

    public GuiButtonInventoryTab(int id, int x, int y, TabType type, Predicate<GuiScreen> selectedPred) {
        super(id, x, y, 32, 28, "");
        this.type = type;
        this.selectedPred = selectedPred;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float f) {
        this.field_146124_l = this.type.shouldRender() && !mc.field_71439_g.func_192035_E().func_192812_b();
        GuiScreen curr = mc.field_71462_r;
        if (curr instanceof GuiContainerCreative && ((GuiContainerCreative)curr).func_147056_g() != CreativeTabs.field_78036_m.func_78021_a()) {
            this.field_146124_l = false;
        }
        if (this.field_146124_l) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(GuiSkills.SKILLS_RES);
            int x = this.field_146128_h;
            int y = this.field_146129_i;
            int u = 176;
            int v = 0;
            int w = this.field_146120_f;
            int h = this.field_146121_g;
            if (this.isSelected()) {
                x += 4;
                u += w;
            }
            this.func_73729_b(x, y, u, v, w, h);
            this.func_73729_b(this.field_146128_h + 12, y + 6, 176 + this.type.iconIndex * 16, 28, 16, 16);
            if (mouseX > this.field_146128_h && mouseY > this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g) {
                InventoryTabHandler.tooltip = new TextComponentTranslation("reskillable.tab." + this.type.name().toLowerCase(), new Object[0]).func_150261_e();
                InventoryTabHandler.mx = mouseX;
                InventoryTabHandler.my = mouseY;
            }
        }
    }

    public boolean isSelected() {
        return this.selectedPred.test(Minecraft.func_71410_x().field_71462_r);
    }

    public static enum TabType {
        INVENTORY(1, null),
        SKILLS(0, null),
        ABILITIES(2, PlayerData::hasAnyAbilities);

        public final int iconIndex;
        private Predicate<PlayerData> renderPred;

        private TabType(int iconIndex, Predicate<PlayerData> render) {
            this.iconIndex = iconIndex;
            this.renderPred = render;
            if (this.renderPred == null) {
                this.renderPred = data -> true;
            }
        }

        public boolean shouldRender() {
            PlayerData data = PlayerDataHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return data != null && this.renderPred.test(data);
        }
    }
}

